<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Money Manager Leaderboard</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
        <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <style>
        body {
            font-family: 'Poppins', sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f8f9fa;
            color: #333;
        }.btn {
    display: inline-block;
    padding: 12px 20px;
    background: #CD7F32;
    color: white;
    font-size: 18px;
    border-radius: 10px;
    text-decoration: none;
    box-shadow: 5px 5px 10px rgba(0, 0, 0, 0.3), -5px -5px 10px rgba(255, 255, 255, 0.2);
    transition: 0.3s;
}

.btn:hover {
    box-shadow: inset 2px 2px 5px rgba(0, 0, 0, 0.2), inset -2px -2px 5px rgba(255, 255, 255, 0.1);
}

        .container {
            max-width: 1200px;
            margin: auto;
            padding: 20px;
            text-align: center;
        }
        .leaderboard {
            display: flex;
            gap: 20px;
            justify-content: center;
            flex-wrap: wrap;
        }
        .leaderboard-card {
            background: linear-gradient(135deg, #ffffff, #dfe6e9);
            padding: 25px;
            border-radius: 20px;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
            width: 45%;
            text-align: center;
            transition: all 0.3s ease-in-out;
            position: relative;
        }
        .leaderboard-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
        }
        .leaderboard-card img {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            margin-bottom: 10px;
            border: 4px solid #555;
        }
        .returns {
            display: flex;
            justify-content: space-around;
            margin-top: 15px;
            font-weight: bold;
            padding: 10px;
            border-radius: 10px;
            background: rgba(0, 0, 0, 0.05);
        }
        .badge {
            position: absolute;
            top: 10px;
            right: 10px;
            background: #CD7F32;
            color: #fff;
            padding: 5px 10px;
            border-radius: 5px;
            font-size: 14px;
        }
       .chart-container {
    width: 100%;
    max-width: 600px; /* Adjust as needed */
    height: 250px; /* Reduce height */
    margin: auto;
}
canvas {
    height: 100% !important;
    width: 100% !important;
}

        /* Table Styling */
        .table-responsive {
            overflow-x: auto;
            width: 100%;
            margin-top: 10px;
        }
        #leaderboardTable {
            width: 100%;
            border-collapse: collapse;
            border-radius: 10px;
            overflow: hidden;
            background: #fff;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        #leaderboardTable thead {
            background: #CD7F32;
            color: white;
        }
        #leaderboardTable th, #leaderboardTable td {
            padding: 12px;
            text-align: center;
            border-bottom: 1px solid #ddd;
        }
        #leaderboardTable tbody tr:nth-child(even) {
            background: #f2f2f2;
        }
        #leaderboardTable tbody tr:hover {
            background: #e0f7e9;
            transition: 0.3s;
        }
        /* Responsive */
        @media (max-width: 768px) {
            .leaderboard {
                flex-direction: column;
            }
            .leaderboard-card {
                width: 100%;
            }
        }.testimonials {
    margin: 40px auto;
    max-width: 800px;
    text-align: center;
}
.testimonial {
    background: #fff;
    padding: 20px;
    border-radius: 10px;
    margin-bottom: 15px;
    box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
}.cta-container {
    background: linear-gradient(135deg, #CD7F32, #218c53);
    color: white;
    padding: 30px;
    border-radius: 15px;
    text-align: center;
    margin: 20px auto;
    max-width: 800px;
}

.search-box {
    width: 100%;
    padding: 10px;
    margin-bottom: 15px;
    border-radius: 5px;
    border: 1px solid #ddd;
}

    </style>
</head>
<body class="bg-gray-100">
<?php include "header.php";?>
    <div class="flex flex-col md:flex-row h-screen">
        <!-- Sidebar -->
        <?php include "side_bar.php";?>

        <!-- Main Content -->
        <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
    <div class="container">
        <input type="text" id="searchInput" placeholder="Search by Name or ID" class="search-box">

        <h2>Money Manager Leaderboard</h2>
                <div class="leaderboard">
                    <div class="leaderboard-card">
                        <span class="badge">#1</span>
                        <img src="https://via.placeholder.com/100" alt="Clark Haley">
                        <h3>Clark Haley</h3>
                        <p>#1000 - 213 days</p>
                        <p>Total Profit: <strong>$4652.63</strong></p>
                        <p>Min. Investment: <strong>$1400.00</strong></p>
                        <p>Total Return: <strong>0.00%</strong></p>
                        <div class="chart-container">
                            <canvas id="chart1"></canvas>
                        </div>
                        <div class="returns">
                            <div><p>1 Year</p><p>0.00%</p></div>
                            <div><p>6 Months</p><p>0.00%</p></div>
                            <div><p>3 Months</p><p>0.00%</p></div>
                        </div>
                    </div>

                    <div class="leaderboard-card">
                        <span class="badge">#2</span>
                        <img src="https://via.placeholder.com/100" alt="Freddy Paulsen">
                        <h3>Freddy Paulsen</h3>
                        <p>#1002 - 213 days</p>
                        <p>Total Profit: <strong>$3355.20</strong></p>
                        <p>Min. Investment: <strong>$1000.00</strong></p>
                        <p>Total Return: <strong class="highlight">14.59%</strong></p>
                        <div class="chart-container">
                            <canvas id="chart2"></canvas>
                        </div>
                        <div class="returns">
                            <div><p>1 Year</p><p class="highlight">14.59%</p></div>
                            <div><p>6 Months</p><p class="highlight">14.59%</p></div>
                            <div><p>3 Months</p><p>0.00%</p></div>
                        </div>
                    </div>
                </div><div class="profit-container" >    <p class="profit-text">Total Profit: <strong class="profit-amount" id="profit1">$0</strong></p>
    <p class="profit-text">Total Profit: <strong class="profit-amount" id="profit2">$0</strong></p>
</div>
<style>
  /* Flex Container */
  .profit-container {
      margin-top:40px;
      display: flex;
      align-items: center;
      gap: 20px; /* Space between items */
  }

  /* Common Styling for Each Profit Section */
  .profit-text {
      font-size: 18px;
      font-weight: bold;
  }

  /* Styling for Profit Amount */
  .profit-amount {
      font-size: 22px;
      padding: 5px 15px;
      border-radius: 5px;
      color: #fff;
  }

  /* Different Colors for Each Profit Value */
  #profit1 {
      background: linear-gradient(45deg, #28a745, #218838);
  }

  #profit2 {
      background: linear-gradient(45deg, #007bff, #0056b3);
  }
</style>



                <h2>Leaderboard Table</h2>
                <div class="table-responsive">
                    <table id="leaderboardTable" class="display">
                        <thead>
                            <tr>
                                <th>Rank</th>
                                <th>Name</th>
                                <th>Account ID</th>
                                <th>Total Profit</th>
                                <th>Min. Investment</th>
                                <th>Total Return</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>#1</td>
                                <td>Clark Haley</td>
                                <td>#1000</td>
                                <td>$4652.63</td>
                                <td>$1400.00</td>
                                <td>0.00%</td>
                            </tr>
                            <tr>
                                <td>#2</td>
                                <td>Freddy Paulsen</td>
                                <td>#1002</td>
                                <td>$3355.20</td>
                                <td>$1000.00</td>
                                <td><span class="highlight">14.59%</span></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
       
        <div id="tradingview_chart"></div>
        <script type="text/javascript" src="https://s3.tradingview.com/tv.js"></script>
        <script type="text/javascript">
            new TradingView.widget({
                "width": "100%",
                "height": 500,
                "symbol": "BINANCE:BTCUSDT",
                "interval": "1",
                "timezone": "Etc/UTC",
                "theme": "dark",
                "style": "1",
                "locale": "en",
                "toolbar_bg": "#f1f3f6",
                "enable_publishing": false,
                "allow_symbol_change": true,
                "container_id": "tradingview_chart"
            });
        </script>



            <section class="testimonials">
    <h2>What Our Investors Say</h2>
    <div class="testimonial">
        <p>"This platform has changed my financial game! The leaderboard helps me track the best traders."</p>
        <strong>- John Doe</strong>
    </div>
    <div class="testimonial">
        <p>"I've made steady returns following top performers. Highly recommended!"</p>
        <strong>- Jane Smith</strong>
    </div>
</section>
<div class="chart-container">
    <h3>Monthly Performance</h3>
    <canvas id="monthlyChart"></canvas>
</div><br><br>
<div class="cta-container">
    <h3>Become a Money Manager!</h3>
    <p>Want to showcase your trading skills? Join our leaderboard and compete with the best.</p>
    <a href="register.php" class="btn">Join Now</a>
</div>


</div><br><br><?php include "footer.php";?>
        </main>
    </div>

    <?php include "footer.php";?>
<script>$("#searchInput").on("keyup", function() {
    var value = $(this).val().toLowerCase();
    $("#leaderboardTable tbody tr").filter(function() {
        $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
    });
});
</script>
    <script>
        function renderChart(chartId, data) {
            new Chart(document.getElementById(chartId), {
                type: 'bar',
                data: { labels: ['1 Year', '6 Months', '3 Months'], datasets: [{ label: 'Returns (%)', data: data, backgroundColor: ['#CD7F32', '#f39c12', '#3498db'], borderWidth: 1 }] },
                options: { responsive: true, scales: { y: { beginAtZero: true } } }
            });
        }
        renderChart('chart1', [0, 0, 0]);
        renderChart('chart2', [14.59, 14.59, 0]);

        $(document).ready(function() {
            $('#leaderboardTable').DataTable();
        });
        new Chart(document.getElementById("monthlyChart"), {
    type: 'line',
    data: {
        labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
        datasets: [{
            label: 'Total Profits ($)',
            data: [1200, 1500, 1800, 2000, 2200, 2500, 2700, 2900, 3100, 3500, 3700, 4000],
            borderColor: '#CD7F32',
            fill: false
        }]
    },
    options: { responsive: true, maintainAspectRatio: false }
});

    </script>
    <script>function animateValue(id, start, end, duration) {
    let obj = document.getElementById(id);
    let range = end - start;
    let increment = range / (duration / 20);
    let current = start;
    
    let timer = setInterval(() => {
        current += increment;
        obj.innerText = "$" + Math.floor(current);
        if (current >= end) {
            clearInterval(timer);
            obj.innerText = "$" + end;
        }
    }, 20);
}

// Start animation when page loads
window.onload = function () {
    animateValue("profit1", 0, 4652, 2000);
    animateValue("profit2", 0, 3355, 2000);
};
</script>
</body>
</html>
