<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nettler Withdraw</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
<?php include "header.php"; ?>
<div class="flex h-screen">
    <?php include "side_bar.php"; ?>

    
    <main class="flex-1 p-6 md:ml-64">
    <!-- Top Navigation -->
    <div class="container">
       <div class="container mx-auto">
                <h1 class="text-4xl font-bold text-center mb-6 text-[#CD7F32]">Nettler Withdraw</h1>

                <!-- Withdraw Form -->
                <form action="add_Nettler_withdraw.php" method="POST" class="max-w-3xl mx-auto bg-white p-10 rounded-lg shadow-xl border border-gray-200">
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Wallet Address -->
                        <div>
                            <label for="wallet_address" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Wallet Address:</label>
                            <input type="text" id="wallet_address" name="wallet_address" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter wallet address">
                        </div>

                        <!-- Amount -->
                        <div>
                            <label for="amount" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Withdraw Amount:</label>
                            <input type="number" id="amount" name="amount" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter Withdraw amount" min="1">
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <div class="mt-8 text-center">
                        <button type="submit" class="w-full md:w-auto px-6 py-3 bg-[#CD7F32] text-white font-semibold rounded-lg shadow-md hover:bg-green-700 transition duration-300">
                            Add Nettler Withdraw
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </main>    <?php include "footer.php";?>

</div>
</body>
</html>
