<?php
include "config.php"; // Include your database connection file

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $wallet_address = $_POST['wallet_address'];
    $amount = $_POST['amount'];

    // Validate amount
    if ($amount <= 0) {
        echo "<script>alert('Amount must be greater than 0.'); window.history.back();</script>";
        exit;
    }

    // Prepare SQL query
    $sql = "INSERT INTO paypal_deposits (wallet_address, amount) VALUES (?, ?)";

    if ($stmt = $conn->prepare($sql)) {
        $stmt->bind_param("sd", $wallet_address, $amount);
        if ($stmt->execute()) {
            echo "<script>alert('PayPal Deposit Added Successfully!'); window.location.href='paypal_deposits_list.php';</script>";
        } else {
            echo "Error executing statement: " . $stmt->error;
        }
        $stmt->close();
    } else {
        echo "Error preparing statement: " . $conn->error;
    }

    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PayPal Deposit</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
    <?php include "header.php"; ?>
    <div class="flex h-screen">
        <?php include "side_bar.php"; ?>

        <main class="flex-1 p-6 md:ml-64">
            <div class="container mx-auto">
                <h1 class="text-4xl font-bold text-center mb-6 text-[#CD7F32]">PayPal Deposit</h1>

                <!-- Deposit Form -->
                <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="POST" class="max-w-3xl mx-auto bg-white p-10 rounded-lg shadow-xl border border-gray-200">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Wallet Address -->
                        <div>
                            <label for="wallet_address" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Wallet Address:</label>
                            <input type="text" id="wallet_address" name="wallet_address" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter wallet address">
                        </div>

                        <!-- Amount -->
                        <div>
                            <label for="amount" class="block text-[#CD7F32] text-lg font-semibold uppercase tracking-wide mb-2">Deposit Amount:</label>
                            <input type="number" id="amount" name="amount" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#CD7F32]" required placeholder="Enter deposit amount" min="1" step="0.01">
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <div class="mt-8 text-center">
                        <button type="submit" class="w-full md:w-auto px-6 py-3 bg-[#CD7F32] text-white font-semibold rounded-lg shadow-md hover:bg-green-700 transition duration-300">
                            Add PayPal Deposit
                        </button>
                    </div>
                </form>
            </div>
        </main>
    </div>
    <?php include "footer.php"; ?>
</body>
</html>
