<?php
/******************************
 * profile.php (single file, no get_states.php / get_cities.php)
 ******************************/
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
ini_set('log_errors', 0);
error_reporting(E_ALL);

register_shutdown_function(function () {
  $e = error_get_last();
  if ($e && in_array($e['type'], [E_ERROR, E_PARSE, E_CORE_ERROR, E_COMPILE_ERROR])) {
    echo "<pre style='background:#fff4f4;border:1px solid #f5c2c7;color:#842029;padding:12px;margin:16px;border-radius:8px'>
<strong>FATAL:</strong> {$e['message']}
in <strong>{$e['file']}</strong> on line <strong>{$e['line']}</strong>
</pre>";
  }
});
set_error_handler(function($errno,$errstr,$errfile,$errline){
  if ($errno === E_NOTICE || $errno === E_WARNING || $errno === E_DEPRECATED) {
    echo "<pre style='background:#fff9db;border:1px solid #ffe69c;color:#664d03;padding:8px 12px;margin:8px 16px;border-radius:6px'>
PHP[$errno]: $errstr
in $errfile:$errline
</pre>";
  }
  return false;
});

session_start();

if (!file_exists(__DIR__ . '/config.php')) {
  echo "<pre style='background:#fff4f4;border:1px solid #f5c2c7;color:#842029;padding:12px;margin:16px;border-radius:8px'>
Missing config.php (expected at " . __DIR__ . "/config.php )</pre>";
  exit;
}
require_once __DIR__ . '/config.php'; // must define $conn (PDO)

if (empty($_SESSION['clogin'])) {
  echo "<div style='padding:20px;font-family:system-ui,Segoe UI,Roboto,Arial'>
  <h3>You are not logged in</h3>
  <p><a href='login.php'>Go to login</a></p>
  </div>
  <script>window.location.replace('login.php');</script>";
  exit;
}

$userEmail = $_SESSION['clogin'];
function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }

/* ------------ ACTIONS (master/favourite/profile/employment/investment/kyc) ------------ */
if (isset($_POST['master'])) {
  $name        = trim($_POST['name'] ?? '');
  $description = trim($_POST['description'] ?? '');
  $tradeid     = trim($_POST['tradeid'] ?? '');
  $commission  = trim($_POST['commission'] ?? $_POST['commisssion'] ?? '');
  $country     = trim($_POST['country'] ?? '');

  $folder = __DIR__ . "/masterdoc/";
  $image  = $_FILES['image']['name'] ?? '';
  $path   = $folder . basename($image);
  $ext    = strtolower(pathinfo($path, PATHINFO_EXTENSION));
  $allowed= ['jpeg','jpg','png','gif'];

  if (!isset($_FILES['image']) || $_FILES['image']['error'] !== UPLOAD_ERR_OK) {
    echo "<script>alert('File upload failed. Try again.');</script>";
  } elseif (!in_array($ext, $allowed, true)) {
    echo "<script>alert('Only JPG, JPEG, PNG & GIF files are allowed.');</script>";
  } elseif (($_FILES['image']['size'] ?? 0) > 5_000_000) {
    echo "<script>alert('File too large (max 5MB).');</script>";
  } else {
    if (!is_dir($folder)) @mkdir($folder, 0755, true);
    if (move_uploaded_file($_FILES['image']['tmp_name'], $path)) {
      try {
        $stmt = $conn->prepare("
          UPDATE liveaccount
          SET strategyname = :name,
              strategyabout = :about,
              strategyimage = :img,
              commission = :commission,
              strategycountry = :country
          WHERE trade_id = :tradeid AND email = :email
        ");
        $stmt->execute([
          ':name'=>$name, ':about'=>$description, ':img'=>basename($image),
          ':commission'=>$commission, ':country'=>$country,
          ':tradeid'=>$tradeid, ':email'=>$userEmail
        ]);
        echo "<script>location.href='requestmaster.php?tradeid=".rawurlencode($tradeid)."';</script>";
        exit;
      } catch (Throwable $e) {
        echo "<script>alert('Database error. Please try again later.');</script>";
      }
    } else {
      echo "<script>alert('Error saving file on server.');</script>";
    }
  }
}

if (isset($_POST['addtofavourite'])) {
  $email       = trim($_POST['email'] ?? $userEmail);
  $tradeid     = trim($_POST['tradeid'] ?? '');
  $name        = trim($_POST['name'] ?? '');
  $description = trim($_POST['about'] ?? '');
  $image       = trim($_POST['image'] ?? '');
  $country     = trim($_POST['country'] ?? '');
  $commission  = trim($_POST['commission'] ?? '');
  try {
    $stmt = $conn->prepare("
      INSERT INTO tbl_favourite (email, tradeid, strategyname, strategyabout, strategyimage, strategycountry, commission, Date)
      VALUES (:email, :tradeid, :name, :about, :image, :country, :commission, NOW())
    ");
    $stmt->execute([
      ':email'=>$email, ':tradeid'=>$tradeid, ':name'=>$name, ':about'=>$description,
      ':image'=>$image, ':country'=>$country, ':commission'=>$commission
    ]);
    echo "<script>location.href='requestfavourite.php?tradeid=".rawurlencode($tradeid)."';</script>";
    exit;
  } catch (Throwable $e) {
    echo "<script>alert('Database error. Please try again later.');</script>";
  }
}

if (isset($_POST['removetofavourite'])) {
  $tradeid = trim($_POST['tradeid'] ?? '');
  try {
    $stmt = $conn->prepare("DELETE FROM tbl_favourite WHERE email = :email AND tradeid = :tradeid");
    $stmt->execute([':email'=>$userEmail, ':tradeid'=>$tradeid]);
    echo "<script>location.href='removefavourite.php?tradeid=".rawurlencode($tradeid)."';</script>";
    exit;
  } catch (Throwable $e) {
    echo "<script>alert('Database error. Please try again later.');</script>";
  }
}

if (isset($_POST['update'])) {
  $fullname  = trim($_POST['fullname'] ?? '');
  $emailid   = trim($_POST['emailid'] ?? '');
  $country   = trim($_POST['country'] ?? '');
  $mnumber   = trim($_POST['mnumber'] ?? '');
  $state     = trim($_POST['state'] ?? '');
  $city      = trim($_POST['city'] ?? '');
  $zipcode   = trim($_POST['zipcode'] ?? '');
  $address   = trim($_POST['address'] ?? '');
  $gender    = trim($_POST['gender'] ?? '');
  $aboutme   = trim($_POST['aboutme'] ?? '');
  $personal_status = 1;

  $stmt = $conn->prepare("
    UPDATE aspnetusers
    SET fullname=:fullname, email=:emailid, country=:country, number=:mnumber,
        state=:state, city=:city, zipcode=:zipcode, address=:address,
        gender=:gender, aboutme=:aboutme, personal_status=:personal_status
    WHERE email=:userEmail
  ");
  $stmt->execute([
    ':fullname'=>$fullname, ':emailid'=>$emailid, ':country'=>$country, ':mnumber'=>$mnumber,
    ':state'=>$state, ':city'=>$city, ':zipcode'=>$zipcode, ':address'=>$address,
    ':gender'=>$gender, ':aboutme'=>$aboutme, ':personal_status'=>$personal_status,
    ':userEmail'=>$userEmail
  ]);
  echo "<script>alert('Your Profile Details Updated successfully');</script>";
}

if (isset($_POST['update_employeement'])) {
  $education       = trim($_POST['education'] ?? '');
  $employee_status = trim($_POST['employee_status'] ?? '');
  $industry        = trim($_POST['industry'] ?? '');
  $employemnet_status = 1;

  $stmt = $conn->prepare("
    UPDATE aspnetusers SET education=:education, employee_status=:employee_status,
      industry=:industry, employemnet_status=:employemnet_status
    WHERE email=:email
  ");
  $stmt->execute([
    ':education'=>$education, ':employee_status'=>$employee_status,
    ':industry'=>$industry, ':employemnet_status'=>$employemnet_status, ':email'=>$userEmail
  ]);
  echo "<script>alert('Your Employment Details Updated successfully');</script>";
}

if (isset($_POST['update_investment'])) {
  $investment_plan    = trim($_POST['investment_plan'] ?? '');
  $funds_source       = trim($_POST['funds_source'] ?? '');
  $investment_purpose = trim($_POST['investment_purpose'] ?? '');

  $stmt = $conn->prepare("
    UPDATE aspnetusers SET investment_plan=:p, funds_source=:f, investment_purpose=:i
    WHERE email=:email
  ");
  $stmt->execute([
    ':p'=>$investment_plan, ':f'=>$funds_source, ':i'=>$investment_purpose, ':email'=>$userEmail
  ]);
  echo "<script>alert('Your Investment Details Updated successfully');</script>";
}

if (isset($_POST['update_kyc'])) {
  $kyc_type  = trim($_POST['kyc_type'] ?? 'Passport');
  $kyc_front = trim($_POST['front_side'] ?? 'Front Side');
  $kyc_back  = trim($_POST['kyc_backside'] ?? 'Reverse Side');

  $folder = __DIR__ . "/_docs/";
  if (!is_dir($folder)) @mkdir($folder, 0755, true);

  $image  = $_FILES['image']['name']  ?? '';
  $image1 = $_FILES['image1']['name'] ?? '';
  $path   = $folder . basename($image);
  $path1  = $folder . basename($image1);

  $allowed = ['jpeg','jpg','png'];
  $ext  = strtolower(pathinfo($path,  PATHINFO_EXTENSION));
  $ext1 = strtolower(pathinfo($path1, PATHINFO_EXTENSION));

  if (!$image || !$image1) {
    echo "<script>alert('Please select both front and back images.');</script>";
  } elseif (!in_array($ext, $allowed, true) || !in_array($ext1, $allowed, true)) {
    echo "<script>alert('Only JPG, JPEG, PNG files are allowed.');</script>";
  } else {
    if (move_uploaded_file($_FILES['image']['tmp_name'], $path) &&
        move_uploaded_file($_FILES['image1']['tmp_name'], $path1)) {

      $stmt = $conn->prepare("
        INSERT INTO kyc_update (email, kyc_type, kyc_frontside, front_image, kyc_backside, back_image)
        VALUES (:e,:t,:fs,:fi,:bs,:bi)
      ");
      $stmt->execute([
        ':e'=>$userEmail, ':t'=>$kyc_type,
        ':fs'=>$kyc_front, ':fi'=>basename($image),
        ':bs'=>$kyc_back,  ':bi'=>basename($image1)
      ]);
      echo "<script>alert('Your KYC Updated successfully');</script>";
    } else {
      echo "<script>alert('Failed to save files. Try again.');</script>";
    }
  }
}

/* ------------ FETCH DATA FOR UI ------------ */
try {
  $stmt = $conn->prepare("SELECT * FROM aspnetusers WHERE email = ?");
  $stmt->execute([$userEmail]);
  $profile = $stmt->fetch(PDO::FETCH_OBJ);
  if (!$profile) {
    $profile = (object)[
      'fullname'=>'','number'=>'','country'=>'India','email'=>$userEmail,
      'state'=>'','city'=>'','zipcode'=>'','address'=>'','gender'=>'',
      'aboutme'=>'','education'=>'','employee_status'=>'','industry'=>'',
      'investment_plan'=>'','investment_purpose'=>'','funds_source'=>''
    ];
  }
} catch (Throwable $e) {
  $profile = (object)[
    'fullname'=>'','number'=>'','country'=>'India','email'=>$userEmail,
    'state'=>'','city'=>'','zipcode'=>'','address'=>'','gender'=>'',
    'aboutme'=>'','education'=>'','employee_status'=>'','industry'=>'',
    'investment_plan'=>'','investment_purpose'=>'','funds_source'=>''
  ];
}

try {
  $stmtKyc = $conn->prepare("
    SELECT id, Status, front_image, back_image
    FROM kyc_update
    WHERE email = ?
    ORDER BY id DESC
    LIMIT 1
  ");
  $stmtKyc->execute([$userEmail]);
  $kycRow = $stmtKyc->fetch(PDO::FETCH_ASSOC) ?: null;
} catch (Throwable $e) { $kycRow = null; }
$statuskyc = h($kycRow['Status']      ?? '');
$img1      = h($kycRow['front_image'] ?? '');
$img2      = h($kycRow['back_image']  ?? '');
$hasKyc    = !empty($kycRow);
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Profile</title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Select2 -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet">
  <!-- Font Awesome (optional) -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">
  <style>
    .nav-tabs .nav-link{background:#e6feff}
    .form-label{font-weight:600}
    .alert-info{padding:8px 12px}
  </style>
</head>
<body class="bg-gray-100">
<?php include "header.php"; ?>
<div class="flex flex-col md:flex-row min-h-screen">
  <?php include "side_bar.php"; ?>

  <main class="flex-1 p-6 md:ml-64">
<style>/* Orange gradient for active tab */
.nav-tabs .nav-link.active {
  background: linear-gradient(135deg, #ff9800, #f57c00);
  color: #fff !important;
  border: none;
  border-radius: 6px 6px 0 0;
  font-weight: 600;
  box-shadow: 0 4px 10px rgba(0,0,0,0.2);
}

/* Normal tab hover effect */
.nav-tabs .nav-link:hover {
  color: #CC5500;
  background: rgba(255, 152, 0, 0.15);
  border-radius: 6px 6px 0 0;
}/* Custom orange gradient button */
.btn-orange {
  background: linear-gradient(135deg, #ff9800, #f57c00);
  border: none;
  color: #fff;
  font-weight: 600;
  padding: 10px 22px;
  border-radius: 8px;
  transition: all 0.3s ease;
  box-shadow: 0 4px 12px rgba(0,0,0,0.2);
}

.btn-orange:hover {
  background: linear-gradient(135deg, #fb8c00, #ef6c00);
  transform: translateY(-2px);
  box-shadow: 0 6px 16px rgba(0,0,0,0.25);
}

</style>


<div class="container my-4">

  <ul class="nav nav-tabs" id="myTab" role="tablist">
    <li class="nav-item"><button class="nav-link active text-dark" id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button">Profile</button></li>
    <li class="nav-item"><button class="nav-link text-dark" id="emp-tab" data-bs-toggle="tab" data-bs-target="#employment" type="button">Employment</button></li>
    <li class="nav-item"><button class="nav-link text-dark" id="equity-tab" data-bs-toggle="tab" data-bs-target="#equity" type="button">Equity</button></li>
    <li class="nav-item"><button class="nav-link text-dark" id="kyc-tab" data-bs-toggle="tab" data-bs-target="#kyc" type="button">KYC Update</button></li>
  </ul>

  <div class="tab-content border border-top-0 bg-white p-3" id="myTabContent">

    <!-- PROFILE -->
    <div class="tab-pane fade show active" id="home" role="tabpanel">
      <h5 class="mb-3">Personal Details</h5>
      <form method="post">
        <div class="row g-3">
          <div class="col-md-6">
            <label class="form-label">Full Name</label>
            <input class="form-control" name="fullname" value="<?= h($profile->fullname) ?>" required>
          </div>
          <div class="col-md-6">
            <label class="form-label">Phone Number</label>
            <input class="form-control" name="mnumber" value="<?= h($profile->number) ?>" required>
          </div>
          <div class="col-md-6">
            <label class="form-label">Country</label>
<select class="form-select" id="country" name="country" required>
  <option value="">-- Select Country --</option>
</select>
          </div>
          <div class="col-md-6">
            <label class="form-label">Email</label>
            <input class="form-control" name="emailid" value="<?= h($profile->email) ?>" readonly required>
          </div>

          <div class="col-md-6">
            <label class="form-label">State</label>
            <select id="state" name="state" class="form-select" required>
              <option value="">-- Select State --</option>
            </select>
          </div>
          <div class="col-md-6">
            <label class="form-label">City</label>
            <select id="city" name="city" class="form-select" required>
              <option value="">-- Select City --</option>
            </select>
          </div>

          <div class="col-md-6">
            <label class="form-label">Zipcode</label>
            <input class="form-control" name="zipcode" value="<?= h($profile->zipcode) ?>" required>
          </div>
          <div class="col-md-6">
            <label class="form-label">Address</label>
            <input class="form-control" name="address" value="<?= h($profile->address) ?>" required>
          </div>

          <div class="col-md-6">
            <label class="form-label">Gender</label>
            <select class="form-select" name="gender" required>
              <option value="" <?= $profile->gender===''?'selected':''; ?> disabled>Select</option>
              <option <?= $profile->gender==='Male'?'selected':''; ?>>Male</option>
              <option <?= $profile->gender==='Female'?'selected':''; ?>>Female</option>
              <option <?= $profile->gender==='Others'?'selected':''; ?>>Others</option>
            </select>
          </div>
          <div class="col-md-6">
            <label class="form-label">Trading Journey</label>
            <select class="form-select" name="aboutme" required>
              <option value="" <?= $profile->aboutme===''?'selected':''; ?> disabled>Select</option>
              <option <?= $profile->aboutme==='Beginner'?'selected':''; ?>>Beginner</option>
              <option <?= $profile->aboutme==='Intermediate'?'selected':''; ?>>Intermediate</option>
              <option <?= $profile->aboutme==='Expert'?'selected':''; ?>>Expert</option>
            </select>
          </div>

          <div class="col-12">
            <button class="btn btn-orange" name="update">Update Profile</button>
          </div>
        </div>
      </form>
    </div>

    <!-- EMPLOYMENT -->
    <div class="tab-pane fade" id="employment" role="tabpanel">
      <h5 class="mb-3">Employment & Education</h5>
      <form method="post">
        <div class="row g-3">
          <div class="col-md-6">
            <label class="form-label">Education</label>
            <select class="form-select" name="education">
              <option value="<?= h($profile->education) ?>" selected><?= h($profile->education ?: 'Select') ?></option>
              <option>High School</option><option>College</option><option>Graduate</option>
              <option>Post Graduate</option><option>Doctorate</option>
            </select>
          </div>
          <div class="col-md-6">
            <label class="form-label">Employment Status</label>
            <select class="form-select" name="employee_status">
              <option value="<?= h($profile->employee_status) ?>" selected><?= h($profile->employee_status ?: 'Select') ?></option>
              <option>Employed</option><option>Retired</option><option>Self Employed</option><option>Student</option><option>Un Employed</option>
            </select>
          </div>
          <div class="col-md-6">
            <label class="form-label">Industry</label>
            <select class="form-select" name="industry">
              <option value="<?= h($profile->industry) ?>" selected><?= h($profile->industry ?: 'Select') ?></option>
              <option>Accountancy</option><option>Admin/Secretarial</option><option>Catering/Hospitality</option>
              <option>Creative/Media</option><option>Education</option><option>Emergency Services</option>
              <option>Engineering</option><option>Financial services</option><option>Health/Medicine</option>
              <option>Armed Forces</option><option>Insurance</option><option>Pharmaceuticals</option>
              <option>Property construction/Real estate</option><option>Retail sales</option><option>Telecommunications</option><option>other</option>
            </select>
          </div>
          <div class="col-12">
            <button class="btn btn-orange" name="update_employeement">Update Employement</button>
          </div>
        </div>
      </form>
    </div>

    <!-- EQUITY -->
    <div class="tab-pane fade" id="equity" role="tabpanel">
      <h5 class="mb-3">Equity Details</h5>
      <form method="post">
        <div class="row g-3">
          <div class="col-md-6">
            <label class="form-label">Planned Investment</label>
            <select class="form-select" name="investment_plan">
              <option value="<?= h($profile->investment_plan) ?>" selected><?= h($profile->investment_plan ?: 'Select') ?></option>
              <option value="<5k">&lt;5k</option><option value="5k-25k">5k-25k</option>
              <option value="25k-100k">25k-100k</option><option value="100k+">100k+</option>
            </select>
          </div>
          <div class="col-md-6">
            <label class="form-label">Purpose of investing</label>
            <select class="form-select" name="investment_purpose">
              <option value="<?= h($profile->investment_purpose) ?>" selected><?= h($profile->investment_purpose ?: 'Select') ?></option>
              <option>Speculative</option><option>Make a living</option>
            </select>
          </div>
          <div class="col-md-6">
            <label class="form-label">Funds Source</label>
            <select class="form-select" name="funds_source">
              <option value="<?= h($profile->funds_source) ?>" selected><?= h($profile->funds_source ?: 'Select') ?></option>
              <option>Salary</option><option>Savings</option><option>Investment</option>
              <option>Business</option><option>Inheritance</option><option value="fundsOther">Other</option>
            </select>
          </div>
          <div class="col-12">
            <button class="btn btn-orange" name="update_investment">Update Investment</button>
          </div>
        </div>
      </form>
    </div>

    <!-- KYC -->
    <div class="tab-pane fade" id="kyc" role="tabpanel">
      <h5 class="mb-3">Update KYC</h5>
      <form method="post" enctype="multipart/form-data">
        <div class="row g-3">
          <div class="col-md-6">
            <label class="form-label">KYC ID Type</label>
            <select class="form-select" name="kyc_type" required>
              <option>Passport</option><option>National ID</option><option>Driving License</option>
            </select>
          </div>

          <?php if ($hasKyc): ?>
          <style>
  .kyc-status-card {
    border-radius: 14px;
    padding: 18px 20px;
    display: flex;
    align-items: center;
    gap: 14px;
    margin-top: 15px;
    color: #fff;
    font-weight: 500;
    box-shadow: 0 6px 18px rgba(0,0,0,0.15);
    background: linear-gradient(135deg, #ff9800, #f57c00); /* orange shades */
  }
  .kyc-status-card i {
    font-size: 1.8rem;
  }
  .kyc-status-card strong {
    font-size: 1.05rem;
  }
</style>

<div class="col-12">
  <?php if (!empty($img1) || !empty($img2)): ?>
    <?php if ($statuskyc === 'Approved'): ?>
      <div class="kyc-status-card">
        <i class="fas fa-check-circle"></i>
        <div>
          <strong>Congratulations!</strong><br>
          Your KYC has been <u>successfully verified</u>. 🎉
        </div>
      </div>
    <?php elseif ($statuskyc === 'Pending'): ?>
      <div class="kyc-status-card">
        <i class="fas fa-hourglass-half"></i>
        <div>
          <strong>Pending Review</strong><br>
          Your KYC is under process. Please wait for confirmation.
        </div>
      </div>
    <?php elseif ($statuskyc === 'Rejected'): ?>
      <div class="kyc-status-card">
        <i class="fas fa-times-circle"></i>
        <div>
          <strong>KYC Rejected</strong><br>
          Unfortunately, your documents didn’t pass verification. Please re-submit valid ones.
        </div>
      </div>
    <?php else: ?>
      <div class="kyc-status-card">
        <i class="fas fa-info-circle"></i>
        <div>
          <strong>KYC Uploaded</strong><br>
          Your documents are in the system. Waiting for review.
        </div>
      </div>
    <?php endif; ?>
  <?php endif; ?>
</div>


          <?php else: ?>
            <div class="col-md-6">
              <label class="form-label">Upload Front Side</label>
              <input type="hidden" name="front_side" value="Front Side">
              <input type="file" class="form-control" name="image" accept="image/*" required>
            </div>
            <div class="col-md-6">
              <label class="form-label">Upload Back Side</label>
              <input type="hidden" name="kyc_backside" value="Reverse Side">
              <input type="file" class="form-control" name="image1" accept="image/*" required>
            </div>
            <div class="col-12">
              <button class="btn btn-orange" name="update_kyc">Update KYC Data</button>
            </div>
          <?php endif; ?>
        </div>
      </form>
    </div>

  </div>
</div>

<!-- JS (Bootstrap, jQuery, Select2) -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.full.min.js"></script>
<script>
// ========== Preselected values from PHP ==========
let prevCountry = <?= json_encode((string)($profile->country ?? 'India')) ?> || 'India';
let prevState   = <?= json_encode((string)($profile->state   ?? '')) ?>;
let prevCity    = <?= json_encode((string)($profile->city    ?? '')) ?>;

// ========== Elements ==========
const countrySel = document.getElementById('country');
const stateSel   = document.getElementById('state');
const citySel    = document.getElementById('city');

// ========== Small helpers ==========
function setOptions(sel, items, placeholder) {
  sel.innerHTML = '';
  const ph = new Option(placeholder, '', true, false);
  ph.disabled = true;
  sel.add(ph);
  items.forEach(v => sel.add(new Option(v, v)));
}

async function fetchJSON(url, opts) {
  const res = await fetch(url, opts);
  if (!res.ok) throw new Error('HTTP ' + res.status);
  return res.json();
}

// ========== Fallbacks (if network fails) ==========
const INDIA_FALLBACK_STATES = [
  "Andhra Pradesh","Arunachal Pradesh","Assam","Bihar","Chhattisgarh","Goa","Gujarat",
  "Haryana","Himachal Pradesh","Jharkhand","Karnataka","Kerala","Madhya Pradesh",
  "Maharashtra","Manipur","Meghalaya","Mizoram","Nagaland","Odisha","Punjab",
  "Rajasthan","Sikkim","Tamil Nadu","Telangana","Tripura","Uttar Pradesh",
  "Uttarakhand","West Bengal","Andaman and Nicobar Islands","Chandigarh",
  "Dadra and Nagar Haveli and Daman and Diu","Delhi","Jammu and Kashmir",
  "Ladakh","Lakshadweep","Puducherry"
];
const INDIA_FALLBACK_CITIES = [
  "Mumbai","Pune","Delhi","Bengaluru","Hyderabad","Chennai","Kolkata","Ahmedabad","Jaipur","Surat","Lucknow"
];

// ========== Loaders ==========
async function loadCountries() {
  let countries = [];
  try {
    // Use Rest Countries for a clean country list
    const data = await fetchJSON('https://restcountries.com/v3.1/all');
    countries = data.map(c => c?.name?.common).filter(Boolean)
                   .sort((a,b) => a.localeCompare(b));
  } catch (e) {
    // Minimal fallback list if offline / blocked
    countries = ["India","United States","United Kingdom","United Arab Emirates","Canada","Australia","Singapore"];
  }

  setOptions(countrySel, countries, '-- Select Country --');

  const chosen = (prevCountry && countries.includes(prevCountry)) ? prevCountry : 'India';
  countrySel.value = chosen;
  await loadStatesForCountry(chosen);
}

async function loadStatesForCountry(country) {
  stateSel.disabled = true;
  citySel.disabled  = true;
  setOptions(stateSel, [], '-- Select State --');
  setOptions(citySel, [], '-- Select City --');

  let states = [];
  try {
    const body = JSON.stringify({ country });
    const j = await fetchJSON('https://countriesnow.space/api/v0.1/countries/states', {
      method: 'POST', headers: { 'Content-Type': 'application/json' }, body
    });
    if (j && j.data && Array.isArray(j.data.states)) {
      states = j.data.states.map(s => s.name).filter(Boolean);
    }
  } catch (e) { /* ignore */ }

  if ((!states || states.length === 0) && country === 'India') {
    states = INDIA_FALLBACK_STATES;
  }

  if (states.length) {
    setOptions(stateSel, states, '-- Select State --');
    stateSel.disabled = false;

    // Preselect previous state if valid
    if (prevState && states.includes(prevState)) {
      stateSel.value = prevState;
      await loadCities(country, prevState);
    } else {
      // Wait for user to choose a state
      setOptions(citySel, [], '-- Select City --');
    }
  } else {
    // Some countries don't have states -> load cities directly by country
    setOptions(stateSel, ['No states for this country'], ''); // informational
    stateSel.disabled = true;
    await loadCities(country, null);
  }
}

async function loadCities(country, state) {
  citySel.disabled = true;
  setOptions(citySel, [], '-- Select City --');

  let cities = [];
  try {
    if (state) {
      const body = JSON.stringify({ country, state });
      const j = await fetchJSON('https://countriesnow.space/api/v0.1/countries/state/cities', {
        method: 'POST', headers: { 'Content-Type': 'application/json' }, body
      });
      if (j && Array.isArray(j.data)) cities = j.data;
    } else {
      const body = JSON.stringify({ country });
      const j = await fetchJSON('https://countriesnow.space/api/v0.1/countries/cities', {
        method: 'POST', headers: { 'Content-Type': 'application/json' }, body
      });
      if (j && Array.isArray(j.data)) cities = j.data;
    }
  } catch (e) { /* ignore */ }

  if ((!cities || cities.length === 0) && country === 'India') {
    cities = INDIA_FALLBACK_CITIES;
  }

  setOptions(citySel, cities, '-- Select City --');
  citySel.disabled = false;

  // Preselect previous city if valid
  if (prevCity && cities.includes(prevCity)) {
    citySel.value = prevCity;
  }
}

// ========== Wire up ==========
document.addEventListener('DOMContentLoaded', async () => {
  // Optional: make selects searchable if you use Select2
  if (window.jQuery && jQuery.fn.select2) {
    $('#country,#state,#city').select2({ width: '100%' });
  }

  await loadCountries();

  countrySel.addEventListener('change', async () => {
    // reset previous selections when country changes
    prevState = ''; prevCity = '';
    await loadStatesForCountry(countrySel.value);
    if (window.jQuery && jQuery.fn.select2) $('#state,#city').val('').trigger('change');
  });

  stateSel.addEventListener('change', async () => {
    prevCity = '';
    await loadCities(countrySel.value, stateSel.value);
    if (window.jQuery && jQuery.fn.select2) $('#city').val('').trigger('change');
  });
});
</script>


</body>
</html>
