<?php
include "config.php"; // Ensure this file connects to your database

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Collect form data
    $performance_fee = $_POST['min_investment'];
    $agreed_to_terms = isset($_POST['agree']) ? 1 : 0; // Check if the user agreed to the terms
    
    // Validate required fields
    if (!empty($performance_fee)) {
        // Assuming the user is logged in and their user_id is stored in a session
        session_start();
        $user_id = $_SESSION['user_id']; // Example: the user's ID from the session
        
        try {
            // Prepare SQL query for insertion
            $sql = "INSERT INTO copier_master_applications (user_id, performance_fee, agreed_to_terms) 
                    VALUES (:user_id, :performance_fee, :agreed_to_terms)";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':user_id', $user_id);
            $stmt->bindParam(':performance_fee', $performance_fee);
            $stmt->bindParam(':agreed_to_terms', $agreed_to_terms);

            // Execute the statement
            if ($stmt->execute()) {
                // Redirect to a success page or show success message
                header("Location: success_page.php");
                exit();
            } else {
                echo "<script>alert('Error submitting your application.');</script>";
            }
        } catch (PDOException $e) {
            // Display the error if the query fails
            echo "<script>alert('Database error: " . $e->getMessage() . "');</script>";
        }
    } else {
        echo "<script>alert('Performance Fee is required.');</script>";
    }
}
?>
