<?php
ob_start(); // Start output buffering
include "config.php";
ini_set('display_errors', 1);
error_reporting(E_ALL);

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name = trim($_POST['name']);
    $email = trim($_POST['email']);
    $subject = trim($_POST['subject']);
    $category = trim($_POST['category']);
    $message = trim($_POST['message']);

    if (!empty($name) && !empty($email) && !empty($subject) && !empty($category) && !empty($message)) {
        try {
            $sql = "INSERT INTO tickets (name, email, subject, category, message) 
                    VALUES (:name, :email, :subject, :category, :message)";
            $stmt = $conn->prepare($sql);

            $stmt->bindParam(':name', $name);
            $stmt->bindParam(':email', $email);
            $stmt->bindParam(':subject', $subject);
            $stmt->bindParam(':category', $category);
            $stmt->bindParam(':message', $message);

            if ($stmt->execute()) {
 $currentPage = basename($_SERVER['PHP_SELF'], ".php"); // Get current page name without extension
    header("Location: succes_page.php?page=$currentPage");
    exit();            } else {
                echo "Insertion failed!";
                print_r($stmt->errorInfo());
            }
        } catch (PDOException $e) {
            echo "Database error: " . $e->getMessage();
        }
    } else {
        echo "All fields are required.";
    }
}
ob_end_flush(); // End output buffering
?>
