<body class="bg-gray-50">
<?php 
include "header.php"; 

// Get the page name from URL parameter
$page = isset($_GET['page']) ? $_GET['page'] : 'unknown';

// Convert underscores to spaces and capitalize words
$page_title = ucwords(str_replace("_", " ", $page));
?>

<div class="flex h-screen">
    <?php include "side_bar.php"; ?>

    <main class="flex-1 p-6 md:ml-64">
        <div class="container">
            <div class="flex h-screen items-center justify-center bg-gray-50">
                <div class="max-w-lg bg-white p-8 rounded-lg shadow-xl border border-gray-200 text-center">
                    <!-- Dynamically change title -->
                    <h1 class="text-4xl font-bold text-[#CD7F32] mb-4">
                        <?php echo $page_title; ?> Added Successfully!
                    </h1>

                    <p class="text-lg text-gray-700 mb-6">
                        Your <?php echo strtolower($page_title); ?> has been successfully added to the system. 
                        You can now continue with your actions or view your history.
                    </p>
                    
                    <!-- Go Back button -->
                    <a href="<?php echo $page; ?>.php" 
                        class="inline-block px-6 py-3 bg-[#CD7F32] text-white font-semibold rounded-lg shadow-md hover:bg-green-700 transition duration-300">
                        Go Back to <?php echo $page_title; ?>
                    </a>
                    
                    <!-- View History button -->
                    <a href="<?php echo $page; ?>_list.php" 
                        class="mt-4 inline-block px-6 py-3 bg-blue-500 text-white font-semibold rounded-lg shadow-md hover:bg-blue-700 transition duration-300">
                        View All <?php echo $page_title; ?>
                    </a>
                </div>
            </div>
        </div>

        <br><br><br>

        <?php include "footer.php"; ?>
    </main>
</div>
</body>
