<?php
// Dummy Data (Simulated dataset)
$deposits = [
    ['id' => 1, 'name' => 'John Doe', 'mt5_id' => 'MT5_1001', 'amount' => 500, 'payment_method' => 'Bank Transfer', 'note' => 'Deposit for trading', 'comment' => 'Verified', 'status' => 'Completed', 'date' => '2025-02-01'],
    ['id' => 2, 'name' => 'Jane Smith', 'mt5_id' => 'MT5_1002', 'amount' => 300, 'payment_method' => 'Crypto', 'note' => 'First deposit', 'comment' => 'Pending review', 'status' => 'Pending', 'date' => '2025-02-02'],
    // Add more dummy records
];

// Get parameters for filtering and pagination
$per_page = isset($_GET['per_page']) ? (int)$_GET['per_page'] : 10;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$start = ($page - 1) * $per_page;

$date_filter = isset($_GET['date_filter']) ? $_GET['date_filter'] : '';
$search = isset($_GET['search']) ? strtolower($_GET['search']) : '';

// Filter Data
$filtered_deposits = array_filter($deposits, function ($deposit) use ($date_filter, $search) {
    if ($date_filter && $deposit['date'] !== $date_filter) {
        return false;
    }
    if ($search && !stripos($deposit['name'], $search) && !stripos($deposit['mt5_id'], $search) && !stripos($deposit['payment_method'], $search)) {
        return false;
    }
    return true;
});

// Paginate Results
$total_deposits = count($filtered_deposits);
$deposits_to_display = array_slice($filtered_deposits, $start, $per_page);
$total_pages = ceil($total_deposits / $per_page);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Wallet History</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50">
<?php include "header.php"; ?>

<div class="flex flex-col md:flex-row h-screen">
    <?php include "side_bar.php"; ?>

    <main class="flex-1 p-6 md:ml-64 overflow-auto">
        <div class="container mx-auto">
            <h1 class="text-3xl font-bold text-center mb-6 text-[#CD7F32]">Wallet History</h1>
            
            <!-- Filter & Search -->
            <div class="mb-6 flex flex-col md:flex-row justify-between items-center space-y-4 md:space-y-0">
                <!-- Date Filter -->
                <form action="team_deposit_report.php" method="GET" class="flex items-center space-x-4">
                    <label for="date_filter" class="text-[#CD7F32] font-semibold">Date:</label>
                    <input type="date" id="date_filter" name="date_filter" class="px-4 py-2 border rounded-lg" value="<?php echo $date_filter; ?>">
                    <button type="submit" class="px-4 py-2 bg-[#CD7F32] text-white rounded-lg">Filter</button>
                </form>

                <!-- Search -->
                <form action="team_deposit_report.php" method="GET" class="flex items-center space-x-4">
                    <input type="text" name="search" placeholder="Search..." value="<?php echo $search; ?>" class="px-4 py-2 border rounded-lg w-full md:w-auto">
                    <button type="submit" class="px-4 py-2 bg-[#CD7F32] text-white rounded-lg">Search</button>
                </form>
            </div>

            <!-- Records Per Page -->
            <div class="mb-6">
                <label for="per_page" class="text-[#CD7F32] font-semibold">Records per page:</label>
                <select id="per_page" name="per_page" class="px-4 py-2 border rounded-lg" onchange="window.location.href = '?per_page=' + this.value;">
                    <option value="10" <?php echo $per_page == 10 ? 'selected' : ''; ?>>10</option>
                    <option value="25" <?php echo $per_page == 25 ? 'selected' : ''; ?>>25</option>
                    <option value="50" <?php echo $per_page == 50 ? 'selected' : ''; ?>>50</option>
                </select>
            </div>

            <!-- Deposit Table -->
            <div class="overflow-x-auto">
                <table class="min-w-full bg-white border rounded-lg shadow-md">
                    <thead>
                        <tr class="text-left bg-gray-100">
                            <th class="px-6 py-3">ID</th>
                            <th class="px-6 py-3">Name</th>
                            <th class="px-6 py-3">MT5 ID</th>
                            <th class="px-6 py-3">Amount</th>
                            <th class="px-6 py-3">Payment Method</th>
                            <th class="px-6 py-3">Note</th>
                            <th class="px-6 py-3">Comment</th>
                            <th class="px-6 py-3">Status</th>
                            <th class="px-6 py-3">Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($deposits_to_display as $deposit): ?>
                            <tr class="border-b">
                                <td class="px-6 py-4"><?php echo $deposit['id']; ?></td>
                                <td class="px-6 py-4"><?php echo $deposit['name']; ?></td>
                                <td class="px-6 py-4"><?php echo $deposit['mt5_id']; ?></td>
                                <td class="px-6 py-4">$<?php echo number_format($deposit['amount'], 2); ?></td>
                                <td class="px-6 py-4"><?php echo $deposit['payment_method']; ?></td>
                                <td class="px-6 py-4"><?php echo $deposit['note']; ?></td>
                                <td class="px-6 py-4"><?php echo $deposit['comment']; ?></td>
                                <td class="px-6 py-4"><?php echo $deposit['status']; ?></td>
                                <td class="px-6 py-4"><?php echo $deposit['date']; ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>
</div>

<?php include "footer.php"; ?>
</body>
</html>
