<?php
//+------------------------------------------------------------------+
//|                                             MetaTrader 5 Web API |
//|                   Copyright 2000-2020, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
error_reporting(0);
include('config.php');

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

class WebPageForm
{
    
    
  const VERIFY_CODE_LENGTH = 5;
  private $user;
  private $verify_code;
  private $root_url;
  private $api;
  /**
   * Construct
   */
  function __construct()
  {
    //---- start session
    session_start();
    //---- initialize
    $this->user = array();
    //---
    $this->root_url = $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
    //---
    $this->api = new MTWebAPI(AGENT, PATH_TO_LOGS);
    $this->api->SetLoggerWriteDebug(IS_WRITE_DEBUG_LOG);
  }
  /**
   * Create web page
   * @return void
   */
  public function CreatePage()
  {
    //---
    if (isset($_REQUEST['a']) && is_array($_REQUEST['a']))
    {
      //--- extract method name
      $methodName = 'On' . key($_REQUEST['a']);
      //--- call the method
      if (method_exists($this, $methodName)) $this->$methodName();
      return;
    }
    $this->Show();
  }
  /**
   * Send email
   * @return void
   */
  private function OnRegister()
  {
    //--- validation request
    //--- receive input
    $this->user = $_REQUEST['user'];
    //----
    foreach ($this->user as $key => $value) $value = trim($value);
    //--- validation input

    include("open_live_account1.php");

     //--- put parameters in our structure
    $new_user = $this->api->UserCreate();
    $new_user->MainPassword = $this->user['password'];
    $new_user->Group = $this->user['group'];
    $new_user->Leverage = $this->user['leverage'];
    $new_user->ZipCode = $this->user['zip'];
    $new_user->Country = $this->user['country'];
    $new_user->State = $this->user['state'];
    $new_user->City = $this->user['city'];
    $new_user->Address = $this->user['address'];
    $new_user->Phone = $this->user['phone'];
    $new_user->Currency = 'USD';
    $new_user->Name = $this->user['name'];
    $new_user->Email = $this->user['email'];
    $new_user->LeadSource1 = $this->user['refer_email1'];
    $new_user->LeadSource2 = $this->user['refer_email2'];
    $new_user->LeadSource3 = $this->user['refer_email3'];
    $new_user->LeadSource4 = $this->user['refer_email4'];
    $new_user->LeadSource5 = $this->user['refer_email5'];
    $new_user->LeadSource6 = $this->user['refer_email6'];
    $new_user->LeadSource7 = $this->user['refer_email7'];
    $new_user->LeadSource8 = $this->user['refer_email8'];
    $new_user->LeadSource9 = $this->user['refer_email9'];
    $new_user->LeadSource10 = $this->user['refer_email10'];
    $new_user->PhonePassword = $this->user['phone_password'];
    $new_user->InvestPassword =$this->user['invest_password'];


    //--- create new account 
   
    
    // Ensure trade_id is exactly 8 characters long


// Send the generated Trade ID as the new user account number to the server
$user_server = $new_user->Login = $this->generateRandomTradeId();

// Now, create a new account
 $this->CreateAccount($new_user, $user_server);
// Store user to database 
$account_type = $new_user->Group;
$currency = $new_user->Currency;
$trade_id = $new_user->Login;
$trader_pwd = $new_user->MainPassword;

$invester_pwd = $new_user->InvestPassword;
$phone_pwd = $new_user->PhonePassword;
$leverage = $new_user->Leverage;
$email = $new_user->Email;
$ib1 = $new_user->LeadSource1;
$ib2 = $new_user->LeadSource2;
$ib3 = $new_user->LeadSource3;
$ib4 = $new_user->LeadSource4;
$ib5 = $new_user->LeadSource5;
$ib6 = $new_user->LeadSource6;
$ib7 = $new_user->LeadSource7;
$ib8 = $new_user->LeadSource8;
$ib9 = $new_user->LeadSource9;
$ib10 = $new_user->LeadSource10;


function generateUUIDv4() {
    // Generate 16 bytes (128 bits) of random data or use a cryptographically secure PRNG
    $data = random_bytes(16);

    // Set version to 0100 (UUIDv4)
    $data[6] = chr((ord($data[6]) & 0x0f) | 0x40);

    // Set the variant to 10x (RFC 4122 compliant)
    $data[8] = chr((ord($data[8]) & 0x3f) | 0x80);

    // Output the 36-character UUID
    return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
}

$usercp = generateUUIDv4();

   $accname = '';
   

   $accname = '';
   
   
  
if ($account_type == "Ali7020\grp4") {
    $accname = "AI Account";
} else if ($account_type == "Ali7020\grp3") {
    $accname = "RAW ECN Account";
} else if ($account_type == "Ali7020\grp2") {
    $accname = "Standrad Account";
} else if ($account_type == "Ali7020\grp1") {
    $accname = "PRO ECN Account";
} 


$servername  = "FXC GLOBAL";

// Store user to database
$sql = "INSERT INTO liveaccount(email,usercp,trade_id,server,account_type,account_name,leverage,currency,trader_pwd,invester_pwd,phone_pwd,ib1,ib2,ib3,ib4,ib5,ib6,ib7,ib8,ib9,ib10)
VALUES (:email,:usercp,:trade_id,:servername,:account_type,:account_name,:leverage,:currency,:trader_pwd,:invester_pwd,:phone_pwd,:ib1,:ib2,:ib3,:ib4,:ib5,:ib6,:ib7,:ib8,:ib9,:ib10)";

$query = $dbh->prepare($sql);
$query->bindParam(':email', $email, PDO::PARAM_STR);
$query->bindParam(':usercp', $usercp, PDO::PARAM_STR);
$query->bindParam(':trade_id', $trade_id, PDO::PARAM_STR);
$query->bindParam(':servername', $servername, PDO::PARAM_STR);
$query->bindParam(':account_type', $account_type, PDO::PARAM_STR);
$query->bindParam(':account_name', $accname, PDO::PARAM_STR);
$query->bindParam(':leverage', $leverage, PDO::PARAM_STR);
$query->bindParam(':currency', $currency, PDO::PARAM_STR);
$query->bindParam(':trader_pwd', $trader_pwd, PDO::PARAM_STR);
$query->bindParam(':invester_pwd', $invester_pwd, PDO::PARAM_STR);
$query->bindParam(':phone_pwd', $phone_pwd, PDO::PARAM_STR);
$query->bindParam(':ib1', $ib1, PDO::PARAM_STR);
$query->bindParam(':ib2', $ib2, PDO::PARAM_STR);
$query->bindParam(':ib3', $ib3, PDO::PARAM_STR);
$query->bindParam(':ib4', $ib4, PDO::PARAM_STR);
$query->bindParam(':ib5', $ib5, PDO::PARAM_STR);
$query->bindParam(':ib6', $ib6, PDO::PARAM_STR);
$query->bindParam(':ib7', $ib7, PDO::PARAM_STR);
$query->bindParam(':ib8', $ib8, PDO::PARAM_STR);
$query->bindParam(':ib9', $ib9, PDO::PARAM_STR);
$query->bindParam(':ib10', $ib10, PDO::PARAM_STR);
$query->execute();
$lastInsertId = $dbh->lastInsertId();

$SQL1="SELECT * FROM liveaccount where email=:email";
 $server= uniqid();
        // Send an email to the CLIENT
        

// Require Composer's autoloader
require 'phpmailer/vendor/autoload.php';

include 'mail/liveaccountmail.php';

                echo "<script>window.location.href='live_account_message.php';</script>";

      
                



      
  }

 
  function CreateAccount($user, &$user_server)
  {
    //--- check connection
    if (!$this->api->IsConnected())
    {
      if (($error_code = $this->api->Connect(MT5_SERVER_IP, MT5_SERVER_PORT, 300, MT5_SERVER_WEB_LOGIN, MT5_SERVER_WEB_PASSWORD)) != MTRetCode::MT_RET_OK)
      {
        echo "<script>
        alert('Something went wrong. Please try again connection');
        </script>";
          
        echo "authentication on MetaTrader Server failed [", $error_code, "] ", MTRetCode::GetError($error_code);
        
        exit;
      }
    }
    //--- add user
    if (($error_code = $this->api->UserAdd($user, $user_server)) != MTRetCode::MT_RET_OK)
    {
     /* echo "<script>
      alert('Something went wrong. Please try again user');
      </script>"; */
      
       echo "<script> alert('Add user on MetaTrader Server failed [", $error_code, "]'); </script>";
   
       exit;
     }
   }
  
  /**
   * Check password
   * @param $password string
   * @return bool
   */
private function generateRandomTradeId()
{
    $prefix = "369";
    $tradeIdLength = 3; // Length of the trade ID excluding the prefix
    $tradeIdFile = 'last_trade_id.txt'; // File to store the last generated trade ID

    // Read the last generated trade ID from the file
    $lastTradeId = file_get_contents($tradeIdFile);

    // Generate a random number for trade ID
    $randomTradeId = mt_rand(1, 99999); // Adjust range as needed

    // Combine prefix and trade ID
    $tradeId = $prefix . str_pad($randomTradeId, $tradeIdLength, '0', STR_PAD_LEFT);

    return $tradeId;
}


 /* function CheckPassword($password)
  {
    $digit = 0;
    $upper = 0;
    $lower = 0;
    //--- check password size
    if (strlen($password) < 5) return (false);
    //--- check password
    for ($i = 0; $i < strlen($password); $i++)
    {
      if (ctype_digit($password[$i])) $digit = 1;
      if (ctype_lower($password[$i])) $lower = 1;
      if (ctype_upper($password[$i])) $upper = 1;
    }
    //--- final check
    return (($digit + $upper + $lower) >= 2);
  }
  /**
   * Generate new verify code
   * @return void
   */
//   private function GenerateVerifyCode()
//   {
//     $random_string = '';
//     for ($i = 0; $i < self::VERIFY_CODE_LENGTH; $i++)
//     {
//       $random_string .= rand(0, 9);
//     }
//     $_SESSION['verify_code'] = $random_string;
//   }
  /**
   * View page
   * @return void
   */
  private function Show()
  {
    // $this->GenerateVerifyCode();
    //---
    include("open_live_account1.php");
  }
}
?>