<?php
// Get the data from the POST request
if (isset($_POST['data'])) {
    $data = $_POST['data'];

    // Split the data into parts by comma
    $dataParts = explode(',', $data); 

    if (count($dataParts) > 4) {
        // First part is trade_id, second is volume, and rest are account types (emails)
        $trade_id = trim($dataParts[0]);
        $volume = trim($dataParts[1]);
        $account = trim($dataParts[2]); // This is the list of emails
        $email = trim($dataParts[3]); // This is the list of emails
        $identifier = array_slice($dataParts, 4); // This is the list of emails

        // Limit the number of emails to 10, filling with 'noIB' if less than 10
        $identifier = array_slice($identifier, 0, 10);
        $accountTypes = array_pad($identifier, 10, 'noIB'); // Pad with 'noIB' if there are fewer than 10 emails

        // Database connection
        $servername = "localhost";
        $username = "crmcentrioglobal_crmvideonew";  // your database username
        $password = "crmvideonew123";  // your database password
        $dbname = "crmcentrioglobal_crmvideonew";  // your database name

        // Create connection
        $conn = new mysqli($servername, $username, $password, $dbname);

        // Check connection
        if ($conn->connect_error) {
            die("Connection failed: " . $conn->connect_error);
        }

        // Prepare SQL to check if the trade_id exists
        $sql = "SELECT * FROM liveaccount WHERE trade_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $trade_id);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            // If trade_id exists, check for volume difference
            $row = $result->fetch_assoc();
            $existingVolume = $row['volume'];

            if ($existingVolume != $volume) {
                // Update the volume and account_types (emails)
                $updateSQL = "UPDATE liveaccount 
                              SET volume = ?  WHERE trade_id = ?";
                $updateStmt = $conn->prepare($updateSQL);
                $updateStmt->bind_param("ss", 
                    $volume, $trade_id
                );
                if ($updateStmt->execute()) {
                    echo "Volume and account types updated successfully!";
                } else {
                    echo "Error updating record: " . $conn->error;
                }
            } else {
                echo "The volume is already the same.";
            }
        } else {
            // If the trade_id does not exist, insert a new record
            $insertSQL = "INSERT INTO liveaccount (trade_id, volume, account_types, email, ib1, ib2, ib3, ib4, ib5, ib6, ib7, ib8, ib9, ib10,ib11,ib12,ib13,ib14,ib15,ib16,ib17,ib18,ib19,ib20) 
                          VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $insertStmt = $conn->prepare($insertSQL);
            $insertStmt->bind_param("ssssssssssssss", 
                $trade_id, $volume, $account, $email, $accountTypes[0], $accountTypes[1], $accountTypes[2], $accountTypes[3], 
                $accountTypes[4], $accountTypes[5], $accountTypes[6], $accountTypes[7], $accountTypes[8], $accountTypes[9], $accountTypes[10],$accountTypes[11],$accountTypes[12],$accountTypes[13],$accountTypes[14],$accountTypes[15],$accountTypes[16],$accountTypes[17],$accountTypes[18],$accountTypes[19]
            );
            if ($insertStmt->execute()) {
                echo "New trade ID added successfully!";
            } else {
                echo "Error inserting record: " . $conn->error;
            }
        }

        // Close the connection
        $conn->close();
    } else {
        echo "Invalid data format. Expected 'trade_id, volume, email1,email2,...'.";
    }
} else {
    echo "No data provided.";
}
?>
